<?php
/* @var $this TuraController */
/* @var $model Tura */

$this->pageTitle = 'Tury - ' . Yii::app()->name;

$this->breadcrumbs = array(
	'Tury'
);

?>
<h1>Zarządzanie turami</h1>

<a style="margin-bottom:15px" class="buttonS bGreen" href="<?php echo $this->createUrl('/administration/tura/create') ?>">Dodaj nową turę</a> (używać tylko w wyjątkowych przypadkach)

<?php

$this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'tury-grid',
	'dataProvider'=>$model->with(array('idKlasy0','idKlasy0.szkola','lekcja'))->search(),
	'filter'=>$model,
	'htmlOptions' => array('class' => 'tDefault'),
	'columns'=>array(
		'id',
		array(
			'header'=>'Czas rozpoczecia',
			'name'=>'czasRozpoczecia',
			'value'=>'$data->czasRozpoczecia',
		),
		array(
			'header'=>'Czas zakończenia',
			'name'=>'czasZakonczenia',
			'value'=>'$data->czasZakonczenia',
		),
		array(
			'header'=>'Klasa',
			'name'=>'idKlasy',
			'value'=>'$data->idKlasy0->nazwa',
		),
		array(
			'header'=>'Szkoła',
			'name'=>'nazwaSzkoly',
			'value'=>'$data->idKlasy0->szkola->nazwa',
		),
		array(
			'header'=>'Lekcja',
			'name'=>'idLekcji',
			'value'=>'$data->lekcja->id',
		),
		array(
			'class'=>'CButtonColumn',
			'template'=>'{view}{update}{delete}',
			'deleteConfirmation'=>"js: 'Na pewno chcesz usunąć wybraną turę?'"
		),
	),
));

?>
